/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.mockingboard;

public class TimedGenerator {
    int sampleRate;
    int clock;
    int period = 1;
    public double counter;
    double cyclesPerSample;
    int clocksPerPeriod;

    private TimedGenerator() {
    }

    public TimedGenerator(int _clock, int _sampleRate) {
        this.setRate(this.clock, this.sampleRate);
        this.reset();
    }

    public int stepsPerCycle() {
        return 1;
    }

    public void setRate(int clock, int sample_rate) {
        this.sampleRate = sample_rate;
        this.clock = clock;
        this.cyclesPerSample = (double)clock / (double)this.sampleRate;
    }

    public void setPeriod(int _period) {
        this.period = _period > 0 ? _period : 1;
        this.clocksPerPeriod = this.period * this.stepsPerCycle();
    }

    protected int updateCounter() {
        this.counter += this.cyclesPerSample;
        int numStateChanges = 0;
        while (this.counter >= (double)this.clocksPerPeriod) {
            this.counter -= (double)this.clocksPerPeriod;
            ++numStateChanges;
        }
        return numStateChanges;
    }

    public void reset() {
        this.counter = 0.0;
        this.period = 1;
    }
}

